import Sidebar from '@/src/components/layout/Sidebar';
import TaskForm from '@/components/tasks/TaskForm';

export default async function EditTaskPage({ params }: { params: Promise<{ id: string }> }) {
    const { id } = await params;
    return (
        <div className="min-h-screen bg-gray-50 flex">
            <Sidebar />
            <div className="flex-1 p-6" dir="rtl">
                <h1 className="text-2xl font-bold mb-6">עריכת משימה #{id}</h1>
                <TaskForm mode="edit" taskId={id} />
            </div>
        </div>
    );
}


